import 'dart:html';

import 'package:photogram_admin_cp/ui/components/layout.dart';
import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/bloc.dart';
import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/data.dart';

class ManageCredentialsPage extends StatefulWidget {
  const ManageCredentialsPage({Key? key}) : super(key: key);

  @override
  _ManageCredentialsPageState createState() => _ManageCredentialsPageState();
}

class _ManageCredentialsPageState extends State<ManageCredentialsPage> with AppActiveContentMixin {
  var _isFormSubmitInProgress = false;
  var _formSubmitError = '';

  @override
  build(context) {
    return PageRow(
      children: [
        Division(
          className: 'col-lg-6',
          children: [
            Division(
              className: 'content-forced',
              children: [
                // page heading and description

                const Heading1(className: 'content-title font-weight-medium', innerText: 'Administration Credentials'),

                const Division(className: 'text-muted font-size-12', innerText: 'Manage your access control'),

                // fields

                Form(
                  onSubmit: _onFormSubmit,
                  children: [
                    FieldSet(
                      children: [
                        const HorizontalRule(className: 'my-20'),
                        Division(
                          children: [
                            const Division(
                              className: 'font-size-14 font-weight-medium',
                              innerText: 'Set a New Username',
                            ),
                            InputText(
                              id: AdminTable.tableName + AdminTable.username,
                              name: AdminTable.tableName + AdminTable.username,
                              value: AuthBloc.of(context).getCurrentAdmin.username,
                              className: 'form-control my-10 px-10 py-15',
                              placeholder: "Leave empty if you don't want to change.",
                            ),
                          ],
                        ),
                        const HorizontalRule(className: 'my-20'),
                        const Division(
                          children: [
                            Division(
                              className: 'font-size-14 font-weight-medium',
                              innerText: 'Set a New Password',
                            ),
                            InputPassword(
                              id: AdminTable.tableName + AdminTable.extraNewPassword,
                              name: AdminTable.tableName + AdminTable.extraNewPassword,
                              className: 'form-control my-10 px-10 py-15',
                              placeholder: "Leave empty if you don't want to change.",
                            ),
                          ],
                        ),
                        const Division(
                          children: [
                            Division(
                              className: 'font-size-14 font-weight-medium',
                              innerText: 'ReType New Password',
                            ),
                            InputPassword(
                              id: AdminTable.tableName + AdminTable.extraRetypeNewPassword,
                              name: AdminTable.tableName + AdminTable.extraRetypeNewPassword,
                              className: 'form-control my-10 px-10 py-15',
                              placeholder: 'Re enter password entered above',
                            ),
                          ],
                        ),
                        const HorizontalRule(className: 'my-20'),
                        const Division(
                          children: [
                            Division(
                              className: 'font-size-14 font-weight-medium',
                              innerText: 'Please enter your current Password to confirm your identity.',
                            ),
                            InputPassword(
                              id: AdminTable.tableName + AdminTable.password,
                              name: AdminTable.tableName + AdminTable.password,
                              className: 'form-control my-10 px-10 py-15',
                              placeholder: 'Enter your current password',
                            ),
                          ],
                        ),
                      ],
                    ),
                    if (!_isFormSubmitInProgress && _formSubmitError.isNotEmpty)
                      Division(
                        className: 'alert alert-secondary my-10',
                        innerText: _formSubmitError,
                      ),
                    const LineBreak(),
                    InputSubmit(
                      className: 'btn btn-primary float-right',
                      value: _isFormSubmitInProgress ? 'Saving...' : 'Save',
                      disabled: _isFormSubmitInProgress,
                    ),
                  ],
                ),
              ],
            ),
          ],
        )
      ],
    );
  }

  void _onFormSubmit(EmittedEvent event) async {
    event.preventDefault();

    if (_isFormSubmitInProgress) return;

    setState(() {
      _isFormSubmitInProgress = true;
    });

    try {
      var form = event.target as FormElement;

      var formData = FormData(form);

      var username = formData.get(AdminTable.tableName + AdminTable.username) as String;
      var password = formData.get(AdminTable.tableName + AdminTable.password) as String;
      var newPassword = formData.get(AdminTable.tableName + AdminTable.extraNewPassword) as String;
      var reTypeNewPassword = formData.get(AdminTable.tableName + AdminTable.extraRetypeNewPassword) as String;

      var doRequest = true;

      if (newPassword.isNotEmpty) {
        if (newPassword != reTypeNewPassword) {
          _formSubmitError = "ReTyped password doesn't matched.";

          doRequest = false;
        }
      }

      if (doRequest) {
        var responseModel = await AppProvider.of(context).apiRepo.preparedRequest(
          requestType: REQ_TYPE_ADMIN_UPDATE_CREDENTIALS,
          requestData: {
            AdminTable.tableName: {
              AdminTable.username: username,
              AdminTable.password: password,
              AdminTable.extraNewPassword: newPassword,
              AdminTable.extraRetypeNewPassword: reTypeNewPassword,
            }
          },
        );

        switch (responseModel.message) {
          case D_ERROR_ADMIN_NOT_MATCHED_MSG:
            _formSubmitError = 'Current password is incorrect.';
            break;

          case SUCCESS_MSG:
            if (!responseModel.contains(AdminTable.tableName)) throw Exception();

            var authedAdmin = AdminModel.fromJson(responseModel.first(AdminTable.tableName));

            if (authedAdmin.isNotModel) throw Exception();

            return AuthBloc.of(context).pushEvent(
              AuthEventPreparing(context, authedAdmin: authedAdmin),
            );

          default:
            _formSubmitError = 'Something went wrong.';
            break;
        }
      }
    } catch (_) {}

    setState(() {
      _isFormSubmitInProgress = false;
    });
  }
}
